/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.perk;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.item.perk.CrystalAttribute;
import dev.toma.gunsrpg.common.item.perk.CrystalItem;
import dev.toma.gunsrpg.common.perk.Perk;
import dev.toma.gunsrpg.common.perk.PerkRegistry;
import dev.toma.gunsrpg.common.perk.PerkType;
import dev.toma.gunsrpg.resource.perks.CrystalConfiguration;
import dev.toma.gunsrpg.resource.perks.PerkConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;

public final class Crystal {
    private final int level;
    private final List<CrystalAttribute> attributes;

    public Crystal(int level, List<CrystalAttribute> attributes) {
        this.level = level;
        this.attributes = attributes;
    }

    public static Map<Perk, List<CrystalAttribute>> groupAttributes(List<CrystalAttribute> attributes) {
        HashMap<Perk, List<CrystalAttribute>> map = new HashMap<Perk, List<CrystalAttribute>>();
        for (CrystalAttribute attribute : attributes) {
            Perk perk = attribute.getPerk();
            map.computeIfAbsent(perk, key -> new ArrayList()).add(attribute);
        }
        return map;
    }

    public static Crystal mergeAndLevelUp(Crystal crystal1, Crystal crystal2, int level) {
        ArrayList<CrystalAttribute> list = new ArrayList<CrystalAttribute>();
        list.addAll(crystal1.attributes);
        list.addAll(crystal2.attributes);
        Map<Perk, List<CrystalAttribute>> map = Crystal.groupAttributes(list);
        Set<Perk> sharedPerks = Crystal.getSharedItems(map);
        ArrayList<CrystalAttribute> result = new ArrayList<CrystalAttribute>();
        for (Map.Entry<Perk, List<CrystalAttribute>> entry : map.entrySet()) {
            CrystalAttribute attribute = CrystalAttribute.flatten(entry.getKey(), entry.getValue());
            result.add(attribute);
        }
        List<CrystalAttribute> buffs = result.stream().filter(type -> type.getType() == PerkType.BUFF).collect(Collectors.toList());
        List<CrystalAttribute> debuffs = result.stream().filter(type -> type.getType() == PerkType.DEBUFF).collect(Collectors.toList());
        CrystalConfiguration.Storage storage = GunsRPG.getModLifecycle().getPerkManager().configLoader.getConfiguration().getCrystalConfig().getStorage();
        int buffLimit = storage.getBuffCapacity() == -1 ? Integer.MAX_VALUE : storage.getBuffCapacity();
        int debuffLimit = storage.getDebuffCapacity() == -1 ? Integer.MAX_VALUE : storage.getDebuffCapacity();
        Random random = new Random();
        if (buffs.size() > buffLimit) {
            Crystal.clearRandomItems(buffs, random, buffs.size() - buffLimit, sharedPerks);
        }
        if (debuffs.size() > debuffLimit) {
            Crystal.clearRandomItems(debuffs, random, debuffs.size() - debuffLimit, sharedPerks);
        }
        result.clear();
        result.addAll(buffs);
        result.addAll(debuffs);
        result.sort(Crystal.compareAttributes());
        return new Crystal(level, result);
    }

    private static Set<Perk> getSharedItems(Map<Perk, List<CrystalAttribute>> map) {
        HashSet<Perk> perkSet = new HashSet<Perk>();
        for (Map.Entry<Perk, List<CrystalAttribute>> entry : map.entrySet()) {
            Perk perk = entry.getKey();
            List<CrystalAttribute> attributes = entry.getValue();
            if (attributes.size() <= 1) continue;
            perkSet.add(perk);
        }
        return perkSet;
    }

    private static void clearRandomItems(List<CrystalAttribute> list, Random random, int amount, Collection<Perk> commonItems) {
        int toRemove = Math.min(amount, list.size());
        int index = 0;
        Iterator<CrystalAttribute> iterator = list.iterator();
        while (iterator.hasNext()) {
            CrystalAttribute attribute = iterator.next();
            if (commonItems.contains(attribute.getPerk())) continue;
            iterator.remove();
            if (++index < toRemove) continue;
            break;
        }
        while (index < toRemove) {
            list.remove(random.nextInt(list.size()));
            ++index;
        }
    }

    public static Crystal generate() {
        PerkConfiguration perkConfig = GunsRPG.getModLifecycle().getPerkManager().configLoader.getConfiguration();
        CrystalConfiguration crystalConfig = perkConfig.getCrystalConfig();
        CrystalConfiguration.Spawns spawns = crystalConfig.getSpawns();
        CrystalConfiguration.Spawn spawn = spawns.getRandomSpawn();
        CrystalConfiguration.Types types = spawns.getTypeRanges();
        return Crystal.generate(spawn.getLevel(), types.getBuffCount(), types.getDebuffCount());
    }

    public static Crystal generate(int level, int buffs, int debuffs) {
        Perk perk;
        int i;
        PerkRegistry registry = PerkRegistry.getRegistry();
        HashSet<CrystalAttribute> set = new HashSet<CrystalAttribute>();
        for (i = 0; i < buffs; ++i) {
            perk = registry.getRandomPerk();
            set.add(new CrystalAttribute(perk, PerkType.BUFF, level));
        }
        for (i = 0; i < debuffs; ++i) {
            perk = registry.getRandomPerk();
            set.add(new CrystalAttribute(perk, PerkType.DEBUFF, level));
        }
        return new Crystal(level, new ArrayList<CrystalAttribute>(set));
    }

    public static Crystal mergeAttributes(int level, Map<PerkType, List<CrystalAttribute>> map) {
        ArrayList<CrystalAttribute> list = new ArrayList<CrystalAttribute>();
        for (List<CrystalAttribute> attributes : map.values()) {
            list.addAll(attributes);
        }
        return new Crystal(level, list);
    }

    public int getLevel() {
        return this.level;
    }

    public List<CrystalAttribute> listAttributes() {
        return this.attributes;
    }

    public boolean hasAnyAttributes() {
        return this.attributes.size() > 0;
    }

    public EnumMap<PerkType, List<CrystalAttribute>> groupByType() {
        EnumMap<PerkType, List<CrystalAttribute>> map = new EnumMap<PerkType, List<CrystalAttribute>>(PerkType.class);
        for (PerkType type : PerkType.values()) {
            map.put(type, new ArrayList());
        }
        for (CrystalAttribute attribute : this.attributes) {
            PerkType type = attribute.getType();
            map.get((Object)type).add(attribute);
        }
        return map;
    }

    public Crystal append(CrystalAttribute attribute) {
        HashSet<CrystalAttribute> set = new HashSet<CrystalAttribute>(this.attributes);
        set.remove(attribute);
        set.add(attribute);
        return new Crystal(this.level, new ArrayList<CrystalAttribute>(set));
    }

    public Crystal remove(CrystalAttribute attribute) {
        ArrayList<CrystalAttribute> copy = new ArrayList<CrystalAttribute>(this.attributes);
        copy.remove(attribute);
        return new Crystal(this.level, copy);
    }

    public ItemStack asItem(CrystalItem item) {
        ItemStack stack = new ItemStack((IItemProvider)item);
        CompoundNBT nbt = new CompoundNBT();
        CompoundNBT crystalNbt = this.toNbt();
        nbt.func_218657_a("crystal", (INBT)crystalNbt);
        stack.func_77982_d(nbt);
        return stack;
    }

    public CompoundNBT toNbt() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("level", this.level);
        ListNBT list = new ListNBT();
        this.attributes.forEach(attr -> list.add((Object)attr.toNbt()));
        nbt.func_218657_a("attributes", (INBT)list);
        return nbt;
    }

    public static Crystal fromNbt(CompoundNBT nbt) {
        int level = Math.max(1, nbt.func_74762_e("level"));
        ListNBT list = nbt.func_150295_c("attributes", 10);
        ArrayList<CrystalAttribute> collection = new ArrayList<CrystalAttribute>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT attrNbt = list.func_150305_b(i);
            CrystalAttribute attribute = CrystalAttribute.fromNbt(attrNbt);
            if (attribute == null) continue;
            collection.add(attribute);
        }
        collection.sort(Crystal.compareAttributes());
        return new Crystal(level, collection);
    }

    public static Comparator<CrystalAttribute> compareAttributes() {
        return Comparator.comparing(CrystalAttribute::getType, (o1, o2) -> o2.ordinal() - o1.ordinal()).thenComparing(CrystalAttribute::getValue).reversed();
    }
}

